#delimit;
clear;
set more off;
set memory 1500m;
set matsize 1000;
global basedirectory "C:\Files\published\gas\upload data\Unemployment Rates from BLS\";
graph set eps fontface Garamond;

*Bureau of Labor Statistics --> Unemployment --> Local Area Unit Statistics (LAUS) -->
*Multiple-Screen --> Statewide --> Seasonally Adjusted --> Column Delimited -->
*Bring into Excel --> Save as CSV file;

*----------------------------------------*;
*----------UNEMPLOYMENT RATES------------*;
*----------------------------------------*;
insheet using "${basedirectory}unemployment.csv"; drop v288 v289;
rename stateregiondivision state;
foreach y in "85" "86" "87" "88" "89" "90" "91" "92" "93" "94" "95" "96" "97" "98" "99" "00" "01" "02" "03" "04" "05" "06" "07" {;
foreach m in "jan" "feb" "mar" "apr" "may" "jun" "jul" "aug" "sep" "oct" "nov" "dec" {; rename `m'`y' d`m'`y';  }; };
foreach m in "jan" "feb" "mar" "apr" "may" "jun" "jul" "aug" "sep" "oct" {; rename `m'08 d`m'08; };
reshape long d, i(state) j(date) string; rename d unemployment;
gen mon=substr(date,1,3); gen year=substr(date,4,5); drop date;
gen month=0; replace month=1 if mon=="jan"; replace month=2  if mon=="feb"; replace month=3  if mon=="mar"; replace month=4  if mon=="apr"; 
		 replace month=5 if mon=="may"; replace month=6  if mon=="jun"; replace month=7  if mon=="jul"; replace month=8  if mon=="aug";  
		 replace month=9 if mon=="sep"; replace month=10 if mon=="oct"; replace month=11 if mon=="nov"; replace month=12 if mon=="dec"; drop mon;
destring year, replace; replace year=1900+year if year>80; replace year=2000+year if year<9; 

*-------------------------------------------------*;
*-------GENERATE STATEFIP VARIABLE----------------*;
*-------------------------------------------------*;
gen statefip=.;   
replace statefip=1 if state=="Alabama"; replace statefip=2 if state=="Alaska";  
replace statefip=4 if state=="Arizona"; replace statefip=5 if state=="Arkansas";
replace statefip=6 if state=="California"; replace statefip=8 if state=="Colorado";  
replace statefip=9 if state=="Connecticut"; replace statefip=10 if state=="Delaware";
replace statefip=11 if state=="District of Columbia"; replace statefip=12 if state=="Florida"; 
replace statefip=13 if state=="Georgia"; replace statefip=15 if state=="Hawaii";
replace statefip=16 if state=="Idaho"; replace statefip=17 if state=="Illinois"; 
replace statefip=18 if state=="Indiana"; replace statefip=19 if state=="Iowa";
replace statefip=20 if state=="Kansas"; replace statefip=21 if state=="Kentucky"; 
replace statefip=22 if state=="Louisiana"; replace statefip=23 if state=="Maine";
replace statefip=24 if state=="Maryland"; replace statefip=25 if state=="Massachusetts"; 
replace statefip=26 if state=="Michigan"; replace statefip=27 if state=="Minnesota";
replace statefip=28 if state=="Mississippi"; replace statefip=29 if state=="Missouri"; 
replace statefip=30 if state=="Montana"; replace statefip=31 if state=="Nebraska";
replace statefip=32 if state=="Nevada"; replace statefip=33 if state=="New Hampshire"; 
replace statefip=34 if state=="New Jersey"; replace statefip=35 if state=="New Mexico";
replace statefip=36 if state=="New York"; replace statefip=37 if state=="North Carolina"; 
replace statefip=38 if state=="North Dakota"; replace statefip=39 if state=="Ohio";
replace statefip=40 if state=="Oklahoma"; replace statefip=41 if state=="Oregon"; 
replace statefip=42 if state=="Pennsylvania"; replace statefip=44 if state=="Rhode Island";
replace statefip=45 if state=="South Carolina"; replace statefip=46 if state=="South Dakota"; 
replace statefip=47 if state=="Tennessee"; replace statefip=48 if state=="Texas";
replace statefip=49 if state=="Utah"; replace statefip=50 if state=="Vermont"; 
replace statefip=51 if state=="Virginia"; replace statefip=53 if state=="Washington";
replace statefip=54 if state=="West Virginia"; replace statefip=55 if state=="Wisconsin"; 
replace statefip=56 if state=="Wyoming"; 
sort statefip year month; save "${basedirectory}unemp.dta", replace;

*-------------------------------------------------*;
*-------NATIONAL UNEMPLOYMENT RATE----------------*;
*-------------------------------------------------*;
clear; insheet using "${basedirectory}national.csv"; 
foreach m in "jan" "feb" "mar" "apr" "may" "jun" "jul" "aug" "sep" "oct" "nov" "dec" {; rename `m' d`m';  };
reshape long d, i(year) j(date) string; rename d unemployment; rename date mon;
gen month=0; replace month=1 if mon=="jan"; replace month=2  if mon=="feb"; replace month=3  if mon=="mar"; replace month=4  if mon=="apr"; 
		 replace month=5 if mon=="may"; replace month=6  if mon=="jun"; replace month=7  if mon=="jul"; replace month=8  if mon=="aug";  
		 replace month=9 if mon=="sep"; replace month=10 if mon=="oct"; replace month=11 if mon=="nov"; replace month=12 if mon=="dec"; drop mon;
sort year month; save "${basedirectory}nationalunemp.dta", replace;

